/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr;

import com.ibm.hwmca.fw.connmgr.HMCSSLContext;
import com.ibm.hwmca.fw.system.CommonSystem;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.net.SocketFactory;

public class HMCSocketFactory
extends SocketFactory {
    private static HMCSocketFactory FACTORY = new HMCSocketFactory();

    static HMCSocketFactory getFactory() {
        return FACTORY;
    }

    static boolean localConnection(int port) {
        return CommonSystem.getCommonSystem().isUsingHTML() && port == 9940;
    }

    static SocketFactory getSocketFactory(int port) {
        SocketFactory factory = null;
        if (HMCSocketFactory.localConnection(port)) {
            factory = SocketFactory.getDefault();
        } else {
            try {
                factory = HMCSSLContext.getSSLContext().getSocketFactory();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return factory;
    }

    private HMCSocketFactory() {
    }

    public Socket createSocket() {
        throw new UnsupportedOperationException();
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return HMCSocketFactory.getSocketFactory(port).createSocket(host, port);
    }

    public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        return HMCSocketFactory.getSocketFactory(port).createSocket(host, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.createSocket(InetAddress.getByName(host), port);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.createSocket(InetAddress.getByName(host), port, localHost, localPort);
    }
}

